/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.conndata;

import com.ibm.hwmca.base.rsf.requests.PhoneListRequestProcessor;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.AccountInfo;
import com.ibm.hwmca.fw.rcs.conndata.AccountingInfo;
import com.ibm.hwmca.fw.rcs.conndata.ConnectivityInfo;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableCountry;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableSubdivision;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.conndata.RetainUpdatableFile;
import com.ibm.hwmca.fw.rcs.conndata.ServerInfo;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ConnectionInfoManager {
    private static final String TRACE_MASKT = "XRCSCIMT";
    private static final String TRACE_MASKF = "XRCSCIMF";
    private static final String TRACE_MASKD = "XRCSCIMD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-ConnIMgr");
    private static ConnectionInfoManager connectionInfoMgr = null;
    private static final String RES_REGIONS = "com.ibm.hwmca.fw.rcs.conndata.res.ConnDataRegions";
    private static final int REFRESH_INTERVAL = 7;
    private Calendar nextRefresh = null;
    private Object refreshLock = new Object();
    private List retainUpdatableFiles = new ArrayList();
    private RetainUpdatableFile attPhoneFile;
    private RetainUpdatableFile retainTcpFile;
    private RetainUpdatableFile piSeriesAcctFile;
    private RetainUpdatableFile storageAcctFile;
    private RetainUpdatableFile zSeriesAcctFile;

    private ConnectionInfoManager() {
        this.initUpdatableFiles();
        Trace.trace(TRACE_MASKT, "<> ConnectionInfoManager()");
    }

    public static synchronized ConnectionInfoManager getConnectionInfoManager() {
        Trace.trace(TRACE_MASKT, "-> getConnectionInfoManager()");
        if (connectionInfoMgr == null) {
            connectionInfoMgr = new ConnectionInfoManager();
        }
        Trace.trace(TRACE_MASKT, "<- getConnectionInfoManager()");
        return connectionInfoMgr;
    }

    private void initUpdatableFiles() {
        Trace.trace(TRACE_MASKT, "-> initUpdatableFiles()");
        try {
            String dataFilePath = BaseFileControl.getFilePath("rcsconndata");
            Trace.trace(TRACE_MASKF, "dataFilePath=" + dataFilePath);
            File attFile = new File(dataFilePath + "actzpho.trm");
            File stagedAttFile = new File(dataFilePath + "ACTZPHO.DAT");
            this.attPhoneFile = new RetainUpdatableFile(attFile, stagedAttFile, "ACTZPHO.DAT", 72);
            this.retainUpdatableFiles.add(this.attPhoneFile);
            File retTcpFile = new File(dataFilePath + "actzcry.trm");
            File stagedRetTcpFile = new File(dataFilePath + "ACTZCRY.DAT");
            this.retainTcpFile = new RetainUpdatableFile(retTcpFile, stagedRetTcpFile, "ACTZCRY.DAT", 120);
            this.retainUpdatableFiles.add(this.retainTcpFile);
            File piAcctFile = new File(dataFilePath + "actzigrp.trm");
            File stagedPiAcctFile = new File(dataFilePath + "ACTZIGRP.DAT");
            this.piSeriesAcctFile = new RetainUpdatableFile(piAcctFile, stagedPiAcctFile, "ACTZIGRP.DAT", 72);
            this.retainUpdatableFiles.add(this.piSeriesAcctFile);
            File storAcctFile = new File(dataFilePath + "actzsgrp.trm");
            File stagedStorAcctFile = new File(dataFilePath + "ACTZSGRP.DAT");
            this.storageAcctFile = new RetainUpdatableFile(storAcctFile, stagedStorAcctFile, "ACTZSGRP.DAT", 72);
            this.retainUpdatableFiles.add(this.storageAcctFile);
            File zAcctFile = new File(dataFilePath + "actzzgrp.trm");
            File stagedZAcctFile = new File(dataFilePath + "ACTZZGRP.DAT");
            this.zSeriesAcctFile = new RetainUpdatableFile(zAcctFile, stagedZAcctFile, "ACTZZGRP.DAT", 72);
            this.retainUpdatableFiles.add(this.zSeriesAcctFile);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- initUpdatableFiles()");
    }

    public List getDisplayableCountries(Locale locale) {
        Trace.trace(TRACE_MASKT, "-> getDisplayableCountries(" + locale + ")");
        ArrayList<String> countries = new ArrayList<String>();
        HashMap<String, DisplayableCountry> countryData = new HashMap<String, DisplayableCountry>();
        try {
            ResourceBundle regions = ResourceBundle.getBundle(RES_REGIONS, locale);
            Enumeration<String> keys = regions.getKeys();
            while (keys.hasMoreElements()) {
                String isoCode = keys.nextElement();
                if (isoCode.length() != 2) continue;
                String desc = regions.getString(isoCode).trim();
                DisplayableCountry country = new DisplayableCountry(isoCode, desc);
                countryData.put(desc, country);
                countries.add(desc);
            }
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "MissingResourceException: " + mre.getMessage());
            new FrameworkLog(classLogInfo, 1936, mre).log();
        }
        Trace.trace(TRACE_MASKF, "Found " + countries.size() + " countries");
        Collator collator = Collator.getInstance(locale);
        Collections.sort(countries, collator);
        int i = 0;
        while (i < countries.size()) {
            String desc = (String)countries.get(i);
            countries.set(i, (String)countryData.get(desc));
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- getDisplayableCountries()");
        return countries;
    }

    public Map getDisplayableSubdivisions(Locale locale) {
        Trace.trace(TRACE_MASKT, "-> getDisplayableSubdivisions(" + locale + ")");
        HashMap subdivisions = new HashMap();
        try {
            ResourceBundle regions = ResourceBundle.getBundle(RES_REGIONS, locale);
            Enumeration<String> keys = regions.getKeys();
            while (keys.hasMoreElements()) {
                List<DisplayableSubdivision> subdivs;
                String isoCode = keys.nextElement();
                if (isoCode.length() < 4) continue;
                String desc = regions.getString(isoCode).trim();
                String isoCountryCode = isoCode.substring(0, 2);
                String isoSubdivCode = isoCode.substring(3);
                DisplayableSubdivision subdiv = new DisplayableSubdivision(isoSubdivCode, desc);
                if (subdivisions.containsKey(isoCountryCode)) {
                    subdivs = (List)subdivisions.get(isoCountryCode);
                    subdivs.add(subdiv);
                    continue;
                }
                subdivs = new ArrayList();
                subdivs.add(subdiv);
                subdivisions.put(isoCountryCode, subdivs);
            }
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "MissingResourceException: " + mre.getMessage());
            new FrameworkLog(classLogInfo, 1936, mre).log();
        }
        int found = subdivisions.size();
        Trace.trace(TRACE_MASKF, "Found " + found + " countries with subdivisions");
        if (found > 0) {
            Collator collator = Collator.getInstance(locale);
            Set keys = subdivisions.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String desc;
                String key = (String)iterator.next();
                List subdivs = (List)subdivisions.get(key);
                Trace.trace(TRACE_MASKF, "Found " + subdivs.size() + " subdivisions for " + key);
                HashMap<String, DisplayableSubdivision> subdivData = new HashMap<String, DisplayableSubdivision>();
                int i = 0;
                while (i < subdivs.size()) {
                    DisplayableSubdivision subdiv = (DisplayableSubdivision)subdivs.get(i);
                    desc = subdiv.getDescription();
                    subdivData.put(desc, subdiv);
                    subdivs.set(i, desc);
                    ++i;
                }
                Collections.sort(subdivs, collator);
                int i2 = 0;
                while (i2 < subdivs.size()) {
                    desc = (String)subdivs.get(i2);
                    subdivs.set(i2, subdivData.get(desc));
                    ++i2;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- getDisplayableSubdivisions()");
        return subdivisions;
    }

    public boolean isSubdivided(String isoCtryCode) {
        Trace.trace(TRACE_MASKT, "-> isSubdivided(" + isoCtryCode + ")");
        boolean subdivided = false;
        try {
            ResourceBundle regions = ResourceBundle.getBundle(RES_REGIONS);
            Enumeration<String> keys = regions.getKeys();
            while (keys.hasMoreElements()) {
                String isoCountryCode;
                String isoCode = keys.nextElement();
                if (isoCode.length() < 4 || !isoCtryCode.equals(isoCountryCode = isoCode.substring(0, 2))) continue;
                subdivided = true;
                break;
            }
        }
        catch (MissingResourceException mre) {
            Trace.trace(TRACE_MASKF, "MissingResourceException: " + mre.getMessage());
            new FrameworkLog(classLogInfo, 1936, mre).log();
        }
        Trace.trace(TRACE_MASKT, "<- isSubdivided() " + subdivided);
        return subdivided;
    }

    public List getPhoneInfo(String ispId, String isoCtryCode, String isoSubdivCode) {
        Trace.trace(TRACE_MASKT, "-> getPhoneInfo(" + ispId + ", " + isoCtryCode + ", " + isoSubdivCode + ")");
        ArrayList<PhoneInfo> phoneInfo = new ArrayList<PhoneInfo>();
        try {
            ArrayList rawPhoneData;
            if (this.attPhoneFile != null) {
                rawPhoneData = this.attPhoneFile.getData();
            } else {
                Trace.trace(TRACE_MASKF, "ISP phone data file unavailable");
                rawPhoneData = new ArrayList();
            }
            boolean ISO_COUNTRY_START = false;
            int ISO_COUNTRY_END = 2;
            int ISO_REGION_START = 3;
            int ISO_REGION_END = 5;
            int LOCATION_START = 6;
            int LOCATION_END = 26;
            int NUMBER_START = 27;
            int NUMBER_END = 59;
            ArrayList<PhoneInfo> multiRegionInfo = new ArrayList<PhoneInfo>();
            boolean countrySubdivided = this.isSubdivided(isoCtryCode);
            int i = 0;
            while (i < rawPhoneData.size()) {
                String data = (String)rawPhoneData.get(i);
                String cCode = data.substring(0, 2).trim();
                String sCode = data.substring(3, 5).trim();
                if (cCode.equals(isoCtryCode)) {
                    PhoneInfo info;
                    String desc = data.substring(6, 26).trim();
                    String number = data.substring(27, 59).trim();
                    if (countrySubdivided) {
                        if (sCode.equals("")) {
                            info = new PhoneInfo(number, desc, cCode, "", number);
                            info.setMultiSubdivision(true);
                            multiRegionInfo.add(info);
                        } else if (sCode.equals(isoSubdivCode)) {
                            info = new PhoneInfo(number, desc, cCode, sCode, number);
                            phoneInfo.add(info);
                        }
                    } else if (sCode.equals(isoSubdivCode)) {
                        info = new PhoneInfo(number, desc, cCode, sCode, number);
                        phoneInfo.add(info);
                    }
                }
                ++i;
            }
            Collections.sort(phoneInfo);
            Collections.sort(multiRegionInfo);
            phoneInfo.addAll(multiRegionInfo);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- getPhoneInfo() " + phoneInfo.size());
        return phoneInfo;
    }

    public AccountingInfo getAccountingInfo(PathPlatform platform, String isoCtryCode, String isoSubdivCode) {
        Trace.trace(TRACE_MASKT, "-> getAccountingInfo(" + platform + ", " + isoCtryCode + ", " + isoSubdivCode + ")");
        AccountingInfo accountingInfo = new AccountingInfo();
        try {
            ArrayList rawAcctData;
            RetainUpdatableFile acctFile = null;
            if (platform == PathPlatform.PISERIES) {
                acctFile = this.piSeriesAcctFile;
            } else if (platform == PathPlatform.STORAGE) {
                acctFile = this.storageAcctFile;
            } else if (platform == PathPlatform.ZSERIES) {
                acctFile = this.zSeriesAcctFile;
            } else if (platform == PathPlatform.GENERIC) {
                acctFile = this.zSeriesAcctFile;
            } else {
                Trace.trace(TRACE_MASKF, "Unsupported path platform: " + platform);
                acctFile = this.zSeriesAcctFile;
            }
            if (acctFile != null) {
                rawAcctData = acctFile.getData();
            } else {
                Trace.trace(TRACE_MASKF, "Account data file unavailable");
                rawAcctData = new ArrayList();
            }
            boolean ISO_COUNTRY_START = false;
            int ISO_COUNTRY_END = 2;
            int ACCOUNT_START = 3;
            int ACCOUNT_END = 11;
            int USERID_START = 12;
            int USERID_END = 20;
            int PASSWORD_START = 21;
            int PASSWORD_END = 29;
            int i = 0;
            while (i < rawAcctData.size()) {
                String data = (String)rawAcctData.get(i);
                String cCode = data.substring(0, 2).trim();
                if (cCode.equals(isoCtryCode)) {
                    String account = data.substring(3, 11).trim();
                    String userId = data.substring(12, 20).trim();
                    String pw = data.substring(21, 29).trim();
                    AccountInfo ursf = new AccountInfo(account, userId, pw, cCode, "");
                    accountingInfo.addAccountInfo("Account_URSF", ursf);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- getAccountingInfo()");
        return accountingInfo;
    }

    public ConnectivityInfo getConnectivityInfo(String isoCtryCode, String isoSubdivCode) {
        Trace.trace(TRACE_MASKT, "-> getConnectivityInfo(" + isoCtryCode + ", " + isoSubdivCode + ")");
        ConnectivityInfo connectivityInfo = new ConnectivityInfo();
        try {
            ArrayList rawConnData;
            if (this.retainTcpFile != null) {
                rawConnData = this.retainTcpFile.getData();
            } else {
                Trace.trace(TRACE_MASKF, "RETAIN TCPIP data file unavailable");
                rawConnData = new ArrayList();
            }
            boolean ISO_COUNTRY_START = false;
            int ISO_COUNTRY_END = 2;
            int ISO_REGION_START = 3;
            int ISO_REGION_END = 5;
            int BUSINESS_UNIT_START = 6;
            int BUSINESS_UNIT_END = 9;
            int AREA_NAME_START = 10;
            int AREA_NAME_END = 30;
            int PRIMARY_IP_START = 31;
            int PRIMARY_IP_END = 47;
            int PRIMARY_PORT_START = 48;
            int PRIMARY_PORT_END = 53;
            int SECONDARY_IP_START = 54;
            int SECONDARY_IP_END = 70;
            int SECONDARY_PORT_START = 71;
            int SECONDARY_PORT_END = 76;
            int ACCOUNT_START = 77;
            int ACCOUNT_END = 85;
            int i = 0;
            while (i < rawConnData.size()) {
                String data = (String)rawConnData.get(i);
                String cCode = data.substring(0, 2).trim();
                String sCode = data.substring(3, 5).trim();
                if (cCode.equals(isoCtryCode) && sCode.equals(isoSubdivCode)) {
                    String ipAddr = data.substring(31, 47).trim();
                    String sPort = data.substring(48, 53).trim();
                    int port = 0;
                    try {
                        port = Integer.parseInt(sPort);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Invalid port " + sPort + " for " + cCode + sCode);
                    }
                    ServerInfo ursf1Server = new ServerInfo(ipAddr, port, cCode, sCode);
                    connectivityInfo.addServerInfo("Server_URSF_Primary", ursf1Server);
                    ipAddr = data.substring(54, 70).trim();
                    sPort = data.substring(71, 76).trim();
                    port = 0;
                    try {
                        port = Integer.parseInt(sPort);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Invalid port " + sPort + " for " + cCode + sCode);
                    }
                    ServerInfo ursf2Server = new ServerInfo(ipAddr, port, cCode, sCode);
                    connectivityInfo.addServerInfo("Server_URSF_Secondary", ursf2Server);
                    break;
                }
                ++i;
            }
            ServerInfo vpnServer = new ServerInfo("207.25.252.196", 0);
            connectivityInfo.addServerInfo("Server_VPN", vpnServer);
            ServerInfo rs3Server = new ServerInfo("198.74.67.235", 11111);
            connectivityInfo.addServerInfo("Server_RS3", rs3Server);
            ServerInfo saServer = new ServerInfo("207.25.252.200", 443);
            connectivityInfo.addServerInfo("Server_SA", saServer);
            ServerInfo sasServer = new ServerInfo("207.25.252.200", 443);
            connectivityInfo.addServerInfo("Server_SAS", sasServer);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e.getMessage());
            new FrameworkLog(classLogInfo, 1936, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- getConnectivityInfo()");
        return connectivityInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUpdatableFiles(boolean force) {
        Trace.trace(TRACE_MASKT, "-> refreshUpdatableFiles(" + force + ")");
        boolean getRefresh = false;
        Object object = this.refreshLock;
        synchronized (object) {
            GregorianCalendar now = new GregorianCalendar();
            if (force || this.nextRefresh == null || now.after(this.nextRefresh)) {
                Trace.trace(TRACE_MASKF, "Refresh needed now");
                this.nextRefresh = now;
                this.nextRefresh.add(5, 7);
                getRefresh = true;
            } else {
                Trace.trace(TRACE_MASKF, "Next scheduled refresh " + this.nextRefresh.getTime());
            }
        }
        if (getRefresh) {
            PhoneListRequestProcessor.getRetainPhoneList(this.retainUpdatableFiles);
        }
        Trace.trace(TRACE_MASKT, "<- refreshUpdatableFiles()");
    }
}

